// More information about this indicator can be found at:
// http://fxcodebase.com/code/viewtopic.php?f=38&t=68338

//+------------------------------------------------------------------+
//|                               Copyright © 2019, Gehtsoft USA LLC | 
//|                                            http://fxcodebase.com |
//+------------------------------------------------------------------+
//|                                      Developed by : Mario Jemic  |
//|                                          mario.jemic@gmail.com   |
//+------------------------------------------------------------------+
//|                                 Support our efforts by donating  |
//|                                  Paypal : https://goo.gl/9Rj74e  |
//+------------------------------------------------------------------+
//|                                Patreon :  https://goo.gl/GdXWeN  |
//|                    BitCoin : 15VCJTLaz12Amr7adHSBtL9v8XomURo9RF  |
//|               BitCoin Cash : 1BEtS465S3Su438Kc58h2sqvVvHK9Mijtg  |
//|           Ethereum : 0x8C110cD61538fb6d7A2B47858F0c0AaBd663068D  |
//|                   LiteCoin : LLU8PSY2vsq7B9kRELLZQcKf5nJQrdeqwD  |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                                Guppy Mulitple Moving Average.mq4 |
//+------------------------------------------------------------------+
// modified by banzai from Mario Jemic template @
// http://fxcodebase.com/code/viewtopic.php?f=38&t=69820
// July 11th, 2020
// not for sale, rent, auction, nor lease

#include <stderror.mqh>
#include <stdlib.mqh>
#property strict

#property copyright "Copyright © 2019, Frosty"

#define VERSION "1.001";
#define INDICATOR_TEXT "GMMA"

#property version VERSION

#property indicator_chart_window

#property indicator_buffers 12
#property indicator_color1 clrBlue
#property indicator_color2 clrBlue
#property indicator_color3 clrBlue
#property indicator_color4 clrBlue
#property indicator_color5 clrBlue
#property indicator_color6 clrBlue
#property indicator_color7 clrRed
#property indicator_color8 clrRed
#property indicator_color9 clrRed
#property indicator_color10 clrRed
#property indicator_color11 clrRed
#property indicator_color12 clrRed

#property indicator_width1 1  
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1
#property indicator_width5 1
#property indicator_width6 1
#property indicator_width7 1
#property indicator_width8 1
#property indicator_width9 1
#property indicator_width10 1
#property indicator_width11 1
#property indicator_width12 1

input string ShortTermNote = "=== Short Term EMA Settings ==";
input int ShortEMAPeriod1 = 3;
input int ShortEMAPeriod2 = 5;
input int ShortEMAPeriod3 = 8;
input int ShortEMAPeriod4 = 10;
input int ShortEMAPeriod5 = 12;
input int ShortEMAPeriod6 = 15;

input string LongTermNote = "=== Long Term EMA Settings ==";
input int LongEMAPeriod1 = 30;
input int LongEMAPeriod2 = 35;
input int LongEMAPeriod3 = 40;
input int LongEMAPeriod4 = 45;
input int LongEMAPeriod5 = 50;
input int LongEMAPeriod6 = 60;


extern string             button_note1          = "------------------------------";
extern ENUM_BASE_CORNER   btn_corner            = CORNER_LEFT_UPPER; // chart btn_corner for anchoring
extern string             btn_text              = "GMMA";
extern string             btn_Font              = "Arial";
extern int                btn_FontSize          = 10;                             //btn__font size
extern color              btn_text_color        = clrWhite;
extern color              btn_background_color  = clrDimGray;
extern color              btn_border_color      = clrBlack;
extern int                button_x              = 20;                                     //btn__x
extern int                button_y              = 13;                                     //btn__y
extern int                btn_Width             = 60;                                 //btn__width
extern int                btn_Height            = 20;                                //btn__height
extern string             button_note2          = "------------------------------";

bool                      show_data             = true;
string IndicatorName, IndicatorObjPrefix;
//template code end1
const string INDICATOR_NAME = INDICATOR_TEXT + " v" + VERSION;

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double ExtMapBuffer7[];
double ExtMapBuffer8[];
double ExtMapBuffer9[];
double ExtMapBuffer10[];
double ExtMapBuffer11[];
double ExtMapBuffer12[];

//+------------------------------------------------------------------+
string GenerateIndicatorName(const string target)
{
   string name = target;
   int try = 2;
   while (WindowFind(name) != -1)
   {
      name = target + " #" + IntegerToString(try++);
   }
   return name;
}
//+------------------------------------------------------------------+
string buttonId;

int init()
{
   IndicatorName = GenerateIndicatorName(btn_text);
   IndicatorObjPrefix = "__" + IndicatorName + "__";
   IndicatorShortName(IndicatorName);
   IndicatorDigits(Digits);
   
   double val;
   if (GlobalVariableGet(IndicatorName + "_visibility", val))
      show_data = val != 0;

// put init() here
   
   SetIndexStyle(0,DRAW_LINE,EMPTY);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_LINE,EMPTY);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(2,DRAW_LINE,EMPTY);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(3,DRAW_LINE,EMPTY);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexStyle(4,DRAW_LINE,EMPTY);
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexStyle(5,DRAW_LINE,EMPTY);
   SetIndexBuffer(5,ExtMapBuffer6);
   
   SetIndexStyle(6,DRAW_LINE,EMPTY);
   SetIndexBuffer(6,ExtMapBuffer7);
   SetIndexStyle(7,DRAW_LINE,EMPTY);
   SetIndexBuffer(7,ExtMapBuffer8);
   SetIndexStyle(8,DRAW_LINE,EMPTY);
   SetIndexBuffer(8,ExtMapBuffer9);
   SetIndexStyle(9,DRAW_LINE,EMPTY);
   SetIndexBuffer(9,ExtMapBuffer10);
   SetIndexStyle(10,DRAW_LINE,EMPTY);
   SetIndexBuffer(10,ExtMapBuffer11); 
   SetIndexStyle(11,DRAW_LINE,EMPTY);
   SetIndexBuffer(11,ExtMapBuffer12); 

   ChartSetInteger(0, CHART_EVENT_MOUSE_MOVE, 1);
   buttonId = IndicatorObjPrefix + "CloseButton";
   createButton(buttonId, btn_text, btn_Width, btn_Height, btn_Font, btn_FontSize, btn_background_color, btn_border_color, btn_text_color);
   ObjectSetInteger(0, buttonId, OBJPROP_YDISTANCE, button_y);
   ObjectSetInteger(0, buttonId, OBJPROP_XDISTANCE, button_x);
   
   return 0;
}
//+------------------------------------------------------------------+
void createButton(string buttonID,string buttonText,int width,int height,string font,int fontSize,color bgColor,color borderColor,color txtColor)
{
      ObjectDelete    (0,buttonID);
      ObjectCreate    (0,buttonID,OBJ_BUTTON,0,0,0);
      ObjectSetInteger(0,buttonID,OBJPROP_COLOR,txtColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BGCOLOR,bgColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_COLOR,borderColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_TYPE,BORDER_RAISED);
      ObjectSetInteger(0,buttonID,OBJPROP_XSIZE,width);
      ObjectSetInteger(0,buttonID,OBJPROP_YSIZE,height);
      ObjectSetString (0,buttonID,OBJPROP_FONT,font);
      ObjectSetString (0,buttonID,OBJPROP_TEXT,buttonText);
      ObjectSetInteger(0,buttonID,OBJPROP_FONTSIZE,fontSize);
      ObjectSetInteger(0,buttonID,OBJPROP_SELECTABLE,0);
      ObjectSetInteger(0,buttonID,OBJPROP_CORNER,btn_corner);
      ObjectSetInteger(0,buttonID,OBJPROP_HIDDEN,1);
      ObjectSetInteger(0,buttonID,OBJPROP_XDISTANCE,9999);
      ObjectSetInteger(0,buttonID,OBJPROP_YDISTANCE,9999);
}
//+------------------------------------------------------------------+
int deinit()
{
   ObjectsDeleteAll(ChartID(), IndicatorObjPrefix);
   return 0;
}
//+------------------------------------------------------------------+
bool recalc = true;

void handleButtonClicks()
{
   if (ObjectGetInteger(0, buttonId, OBJPROP_STATE))
   {
      ObjectSetInteger(0, buttonId, OBJPROP_STATE, false);
      show_data = !show_data;
      GlobalVariableSet(IndicatorName + "_visibility", show_data ? 1.0 : 0.0);
      recalc = true;
      start();
   }
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
{
   handleButtonClicks();
}
//+------------------------------------------------------------------+
int start()
{
   handleButtonClicks();
   if (Bars <= 3) 
      return(0);
   int ExtCountedBars = IndicatorCounted();
   if (ExtCountedBars < 0) 
      return(-1);
   int limit = Bars - 2;
   if (ExtCountedBars > 2 && !recalc) 
      limit = Bars - ExtCountedBars - 1;

   recalc = false;

   for(int i = 0; i< limit; i++)
   {
      if (show_data)
      {
         //short periods
         ExtMapBuffer1[i]=iMA(NULL,0,ShortEMAPeriod1,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer2[i]=iMA(NULL,0,ShortEMAPeriod2,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer3[i]=iMA(NULL,0,ShortEMAPeriod3,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer4[i]=iMA(NULL,0,ShortEMAPeriod4,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer5[i]=iMA(NULL,0,ShortEMAPeriod5,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer6[i]=iMA(NULL,0,ShortEMAPeriod6,0,MODE_EMA,PRICE_CLOSE,i);
      
         //long periods
         ExtMapBuffer7[i]=iMA(NULL,0,LongEMAPeriod1,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer8[i]=iMA(NULL,0,LongEMAPeriod2,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer9[i]=iMA(NULL,0,LongEMAPeriod3,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer10[i]=iMA(NULL,0,LongEMAPeriod4,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer11[i]=iMA(NULL,0,LongEMAPeriod5,0,MODE_EMA,PRICE_CLOSE,i);
         ExtMapBuffer12[i]=iMA(NULL,0,LongEMAPeriod6,0,MODE_EMA,PRICE_CLOSE,i);
         for (int banzai = 0; banzai< 12; banzai++)
            SetIndexStyle(banzai,DRAW_LINE);
      } //if (show_data)
      else
      {
         for (int banzai = 0; banzai< 12; banzai++)
            SetIndexStyle(banzai,DRAW_NONE);
      }

   } //for(i = 0; i< limit; i++)
   return 0;
}
//+------------------------------------------------------------------+

